# test code
# Copyright 2008 by Brian C. Christensen

# 080916 - start first draft
# 081119 - redraw diagram after inserting duplicate graphics

import ORM

debug = 1

def NewGraphic(report, model_object, g='ORMObjectTypeShape'):
    '''creates object of obj_type witn name
        name can be used to look up object'''
    shape = report.db.GetObject('GraphicObject', subtype=g)  # create a new "row" (anything appearing in the report)
    shape.ProjectID = report.ProjectID
    shape.Target = model_object

    shape.ReportID  = report.ID
    shape.PosX, shape.PosY = report.posx, report.posy

    report._SetInShell('posy', report.posy + 40)
    if report.posy >= 1000:
        report._SetInShell('posy', 20)
        report._SetInShell('posx', report.posx + 40)
    return shape


def InsertObjectTypeCopy(report):
    object_types = report.Project.GetList('ORMObjectType')
    object_types.sort(cmp=lambda x,y: cmp(x.Name, y.Name))

    report._SetInShell('posx', 200)
    report._SetInShell('posy', 40)
    
    lst = [ x.Name or '' for x in object_types ]

    dlg = wx.MultiChoiceDialog( self, 
                               "Pick object types",
                               "wx.MultiChoiceDialog", lst)

    if (dlg.ShowModal() == wx.ID_OK):
        selections = dlg.GetSelections()
        selected = [object_types[x] for x in selections]
##        self.log.write("Selections: %s -> %s\n" % (selections, strings))
        dlg.Destroy()

        for x in selected:
            graphic = NewGraphic(report, x)
            # graphic.Draw()  # need to draw the new objects

        Data.SetUndo('Add Object Type Copy')
##        report.win.RedrawAll()  # doesn't work, why?
        self.Report.win.RedrawAll() # or just redraw new objects?
        return True
    return False

def Do(self):
    rid = self.ReportID  # current report
    if rid == 1 :
        hint('Not for use in main report')
        return  # do nothing

    db = Data.DBObject  # will get objects from this database
    report = db.GetObject('Report',rid)

    result = InsertObjectTypeCopy( report )

Do(self)

